/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker;

import LegendaryCardMaker.CustomCardMaker.CustomCardMaker;
import LegendaryCardMaker.CustomCardMaker.structure.CustomCard;
import LegendaryCardMaker.CustomCardMaker.structure.CustomStructure;
import LegendaryCardMaker.CustomCardMaker.structure.CustomTemplate;
import LegendaryCardMaker.Icon;
import LegendaryCardMaker.LegendaryCardMakerFrame;
import LegendaryCardMaker.LegendaryHeroMaker.CardRarity;
import LegendaryCardMaker.LegendaryHeroMaker.Hero;
import LegendaryCardMaker.LegendaryHeroMaker.HeroCard;
import LegendaryCardMaker.LegendaryHeroMaker.HeroMaker;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeCard;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeCardType;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeMaker;
import LegendaryCardMaker.LegendaryVillainMaker.Villain;
import LegendaryCardMaker.LegendaryVillainMaker.VillainCard;
import LegendaryCardMaker.LegendaryVillainMaker.VillainCardType;
import LegendaryCardMaker.LegendaryVillainMaker.VillainMaker;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;

public class LegendaryCardMaker {
    public static String version = "0.12";
    public static boolean debug = true;
    public String inputFile = null;
    public boolean exportBasicText = false;
    public String textOutputFile = null;
    public String textErrorFile = "error.txt";
    public String exportFolder = null;
    public List<Hero> heroes = new ArrayList<Hero>();
    public List<Villain> villains = new ArrayList<Villain>();
    public List<SchemeCard> schemes = new ArrayList<SchemeCard>();
    public List<CustomCard> customCards = new ArrayList<CustomCard>();
    public Villain bystanderVillain = new Villain();
    public Villain woundVillain = new Villain();
    public Villain bindingsVillain = new Villain();
    public List<CustomStructure> customStructures = new ArrayList<CustomStructure>();
    public List<CustomTemplate> allTemplates = new ArrayList<CustomTemplate>();
    public List<CustomStructure> allStructures = new ArrayList<CustomStructure>();
    public boolean ignoreGenerate = true;
    public String textDividerFile = "cardCreator/dividers.txt";
    public boolean generateDividerFile = false;
    public String currentFile = null;
    public String lastSaved = null;
    public String lastOpened = null;
    public static String expansionStyle = "default";
    public boolean dividerHorizontal = true;
    public String dfImagePath;
    public double dfImageZoom = 1.0;
    public int dfImageOffsetX = 0;
    public int dfImageOffsetY = 0;
    public String dbImagePath;
    public double dbImageZoom = 1.0;
    public int dbImageOffsetX = 0;
    public int dbImageOffsetY = 0;
    public boolean dividerTitleBarVisible = true;
    public Color dividerTitleBarColour = Color.WHITE;
    public String dividerCardStyle = "PowerIcons";
    public String dividerBodyStyle = "Images";
    public String expansionName = "";
    public String rules = "";
    public String keywords = "";

    public static void main(String[] args) {
        LegendaryCardMaker lcm = new LegendaryCardMaker();
        new LegendaryCardMakerFrame(lcm);
    }

    public LegendaryCardMaker() {
        this.bystanderVillain.name = "system_bystander_villain";
        this.villains.add(this.bystanderVillain);
        this.woundVillain.name = "system_wound_villain";
        this.villains.add(this.woundVillain);
        this.bindingsVillain.name = "system_bindings_villain";
        this.villains.add(this.bindingsVillain);
        this.loadTemplates();
        this.loadStructures();
    }

    /*
     * Unable to fully structure code
     */
    public void processInput(String inputFile) {
        this.heroes = new ArrayList<Hero>();
        this.villains = new ArrayList<Villain>();
        this.schemes = new ArrayList<SchemeCard>();
        this.customCards = new ArrayList<CustomCard>();
        this.bystanderVillain = new Villain();
        this.bystanderVillain.name = "system_bystander_villain";
        this.villains.add(this.bystanderVillain);
        this.woundVillain = new Villain();
        this.woundVillain.name = "system_wound_villain";
        this.villains.add(this.woundVillain);
        this.bindingsVillain = new Villain();
        this.bindingsVillain.name = "system_bindings_villain";
        this.villains.add(this.bindingsVillain);
        this.expansionName = "";
        this.keywords = "";
        this.rules = "";
        h = new Hero();
        hc = new HeroCard();
        hm = new HeroMaker();
        v = new Villain();
        vc = new VillainCard();
        vm = new VillainMaker();
        sc = new SchemeCard();
        sm = new SchemeMaker();
        cc = new CustomCard();
        try {
            fw = null;
            bw = null;
            if (this.exportBasicText) {
                fw = new FileWriter(new File(this.textOutputFile));
                bw = new BufferedWriter(fw);
            }
            fwDiv = null;
            bwDiv = null;
            if (this.generateDividerFile) {
                fwDiv = new FileWriter(new File(this.textDividerFile));
                bwDiv = new BufferedWriter(fwDiv);
            }
            fwErr = null;
            bwErr = null;
            fwErr = new FileWriter(new File(this.textErrorFile));
            bwErr = new BufferedWriter(fwErr);
            br = new BufferedReader(new FileReader(new File(inputFile)));
            while ((line = br.readLine()) != null) {
                block143: {
                    block142: {
                        block141: {
                            if (line == null || line.startsWith("#") || line.isEmpty()) continue;
                            if (line.startsWith("EXPANSIONSTYLE;")) {
                                LegendaryCardMaker.expansionStyle = line.replace("EXPANSIONSTYLE;", "");
                            }
                            if (line.startsWith("EXPANSIONNAME;")) {
                                this.expansionName = line.replace("EXPANSIONNAME;", "");
                            }
                            if (line.startsWith("RULES;")) {
                                this.rules = line.replace("RULES;", "");
                            }
                            if (line.startsWith("KEYWORDS;")) {
                                this.keywords = line.replace("KEYWORDS;", "");
                            }
                            if (line.startsWith("DIVIDERORIENTATION;")) {
                                orientation = line.replace("DIVIDERORIENTATION;", "");
                                this.dividerHorizontal = orientation == null || orientation.equals("VERTICAL") == false;
                            }
                            if (line.startsWith("DIVIDERCARDSTYLE;")) {
                                this.dividerCardStyle = line.replace("DIVIDERCARDSTYLE;", "");
                            }
                            if (line.startsWith("DIVIDERBODYSTYLE;")) {
                                this.dividerBodyStyle = line.replace("DIVIDERBODYSTYLE;", "");
                            }
                            if (line.startsWith("DFIMAGEZOOM;")) {
                                this.dfImageZoom = Double.parseDouble(line.replace("DFIMAGEZOOM;", ""));
                            }
                            if (line.startsWith("DFIMAGEPATH;")) {
                                this.dfImagePath = line.replace("DFIMAGEPATH;", "");
                            }
                            if (line.startsWith("DFIMAGEOFFSETX;")) {
                                this.dfImageOffsetX = Integer.parseInt(line.replace("DFIMAGEOFFSETX;", ""));
                            }
                            if (line.startsWith("DFIMAGEOFFSETY;")) {
                                this.dfImageOffsetY = Integer.parseInt(line.replace("DFIMAGEOFFSETY;", ""));
                            }
                            if (line.startsWith("DBIMAGEZOOM;")) {
                                this.dbImageZoom = Double.parseDouble(line.replace("DBIMAGEZOOM;", ""));
                            }
                            if (line.startsWith("DBIMAGEPATH;")) {
                                this.dbImagePath = line.replace("DBIMAGEPATH;", "");
                            }
                            if (line.startsWith("DBIMAGEOFFSETX;")) {
                                this.dbImageOffsetX = Integer.parseInt(line.replace("DBIMAGEOFFSETX;", ""));
                            }
                            if (line.startsWith("DBIMAGEOFFSETY;")) {
                                this.dbImageOffsetY = Integer.parseInt(line.replace("DBIMAGEOFFSETY;", ""));
                            }
                            if (line.startsWith("DTITLEBARVISIBLE;")) {
                                this.dividerTitleBarVisible = Boolean.parseBoolean(line.replace("DTITLEBARVISIBLE;", ""));
                            }
                            if (line.startsWith("DTITLEBARCOLOUR;") && (c = new Color(rgb = Integer.valueOf(Integer.parseInt(line.replace("DTITLEBARCOLOUR;", ""))))) != null) {
                                this.dividerTitleBarColour = c;
                            }
                            if (line.startsWith("HCTCARDNAMESIZE;")) {
                                HeroMaker.cardNameSizeTemplate = Integer.parseInt(line.replace("HCTCARDNAMESIZE;", ""));
                            }
                            if (line.startsWith("HCTCARDNAMEFONTNAME;")) {
                                HeroMaker.cardNameFontNameTemplate = line.replace("HCTCARDNAMEFONTNAME;", "");
                            }
                            if (line.startsWith("HCTCARDNAMEFONTSTYLE;")) {
                                HeroMaker.cardNameFontStyleTemplate = Integer.parseInt(line.replace("HCTCARDNAMEFONTSTYLE;", ""));
                            }
                            if (line.startsWith("HCTHERONAMESIZE;")) {
                                HeroMaker.heroNameSizeTemplate = Integer.parseInt(line.replace("HCTHERONAMESIZE;", ""));
                            }
                            if (line.startsWith("HCTHERONAMEFONTNAME;")) {
                                HeroMaker.heroNameFontNameTemplate = line.replace("HCTHERONAMEFONTNAME;", "");
                            }
                            if (line.startsWith("HCTHERONAMEFONTSTYLE;")) {
                                HeroMaker.heroNameFontStyleTemplate = Integer.parseInt(line.replace("HCTHERONAMEFONTSTYLE;", ""));
                            }
                            if (line.startsWith("HCTABILITYTEXTSIZE;")) {
                                HeroMaker.abilityTextSizeTemplate = Integer.parseInt(line.replace("HCTABILITYTEXTSIZE;", ""));
                            }
                            if (line.startsWith("HCTABILITYTEXTFONTNAME;")) {
                                HeroMaker.abilityTextFontNameTemplate = line.replace("HCTABILITYTEXTFONTNAME;", "");
                            }
                            if (line.startsWith("HCTABILITYTEXTFONTSTYLE;")) {
                                HeroMaker.abilityTextFontStyleTemplate = Integer.parseInt(line.replace("HCTABILITYTEXTFONTSTYLE;", ""));
                            }
                            if (line.startsWith("HCTCARDNAMECOLOUR;")) {
                                HeroMaker.cardNameColorTemplate = new Color(Integer.parseInt(line.replace("HCTCARDNAMECOLOUR;", "")));
                            }
                            if (line.startsWith("HCTHERONAMECOLOUR;")) {
                                HeroMaker.heroNameColorTemplate = new Color(Integer.parseInt(line.replace("HCTHERONAMECOLOUR;", "")));
                            }
                            if (line.startsWith("HCTABILITYTEXTCOLOUR;")) {
                                HeroMaker.abilityTextColorTemplate = new Color(Integer.parseInt(line.replace("HCTABILITYTEXTCOLOUR;", "")));
                            }
                            if (line.startsWith("HCTTEAMPOWERUNDERLAYCOLOUR;")) {
                                HeroMaker.teamPowerUnderlayColorTemplate = new Color(Integer.parseInt(line.replace("HCTTEAMPOWERUNDERLAYCOLOUR;", "")));
                            }
                            if (line.startsWith("HCTTEAMPOWERBLURRADIUS;")) {
                                HeroMaker.teamPowerBlurRadiusTemplate = Integer.parseInt(line.replace("HCTTEAMPOWERBLURRADIUS;", ""));
                            }
                            if (line.startsWith("HCTNAMEHIGHLIGHTTYPE;")) {
                                HeroMaker.nameHighlightTemplate = line.replace("HCTNAMEHIGHLIGHTTYPE;", "");
                            }
                            if (line.startsWith("HCTCOSTSIZE;")) {
                                HeroMaker.costSizeTemplate = Integer.parseInt(line.replace("HCTCOSTSIZE;", ""));
                            }
                            if (line.startsWith("HCTCOSTFONTNAME;")) {
                                HeroMaker.costFontNameTemplate = line.replace("HCTCOSTFONTNAME;", "");
                            }
                            if (line.startsWith("HCTCOSTFONTSTYLE;")) {
                                HeroMaker.costFontStyleTemplate = Integer.parseInt(line.replace("HCTCOSTFONTSTYLE;", ""));
                            }
                            if (line.startsWith("HCTCOSTCOLOUR;")) {
                                HeroMaker.costColorTemplate = new Color(Integer.parseInt(line.replace("HCTCOSTCOLOUR;", "")));
                            }
                            if (line.startsWith("HCTATTACKSIZE;")) {
                                HeroMaker.attackSizeTemplate = Integer.parseInt(line.replace("HCTATTACKSIZE;", ""));
                            }
                            if (line.startsWith("HCTATTACKFONTNAME;")) {
                                HeroMaker.attackFontNameTemplate = line.replace("HCTATTACKFONTNAME;", "");
                            }
                            if (line.startsWith("HCTATTACKFONTSTYLE;")) {
                                HeroMaker.attackFontStyleTemplate = Integer.parseInt(line.replace("HCTATTACKFONTSTYLE;", ""));
                            }
                            if (line.startsWith("HCTATTACKCOLOUR;")) {
                                HeroMaker.attackColorTemplate = new Color(Integer.parseInt(line.replace("HCTATTACKCOLOUR;", "")));
                            }
                            if (line.startsWith("HCTRECRUITSIZE;")) {
                                HeroMaker.recruitSizeTemplate = Integer.parseInt(line.replace("HCTRECRUITSIZE;", ""));
                            }
                            if (line.startsWith("HCTRECRUITFONTNAME;")) {
                                HeroMaker.recruitFontNameTemplate = line.replace("HCTRECRUITFONTNAME;", "");
                            }
                            if (line.startsWith("HCTRECRUITFONTSTYLE;")) {
                                HeroMaker.recruitFontStyleTemplate = Integer.parseInt(line.replace("HCTRECRUITFONTSTYLE;", ""));
                            }
                            if (line.startsWith("HCTRECRUITCOLOUR;")) {
                                HeroMaker.recruitColorTemplate = new Color(Integer.parseInt(line.replace("HCTRECRUITCOLOUR;", "")));
                            }
                            if (line.startsWith("HCTDUALCLASSSTYLE;")) {
                                HeroMaker.dualClassStyle = HeroMaker.DUAL_CLASS_STYLE.valueOf(line.replace("HCTDUALCLASSSTYLE;", ""));
                            }
                            if (line.startsWith("HERO;")) {
                                h = new Hero();
                                h.name = line.replace("HERO;", "");
                                this.heroes.add(h);
                                if (this.exportBasicText) {
                                    this.outputHero(bw, h);
                                }
                            }
                            if (line.startsWith("HFIMAGEZOOM;")) {
                                h.imageZoom = Double.parseDouble(line.replace("HFIMAGEZOOM;", ""));
                            }
                            if (line.startsWith("HFIMAGEPATH;")) {
                                h.imagePath = line.replace("HFIMAGEPATH;", "");
                            }
                            if (line.startsWith("HFIMAGEOFFSETX;")) {
                                h.imageOffsetX = Integer.parseInt(line.replace("HFIMAGEOFFSETX;", ""));
                            }
                            if (line.startsWith("HFIMAGEOFFSETY;")) {
                                h.imageOffsetY = Integer.parseInt(line.replace("HFIMAGEOFFSETY;", ""));
                            }
                            if (line.startsWith("HEROCARD;")) {
                                hm = new HeroMaker();
                                hm.bwErr = bwErr;
                                hm.exportFolder = this.exportFolder;
                                hc = new HeroCard();
                                hc.heroName = h.name;
                                h.cards.add(hc);
                            }
                            if (line.startsWith("HCNAME;")) {
                                hc.name = line.replace("HCNAME;", "");
                            }
                            if (line.startsWith("HCNAMESIZE;")) {
                                hm.cardNameSize = Integer.parseInt(line.replace("HCNAMESIZE;", ""));
                                hc.nameSize = Integer.parseInt(line.replace("HCNAMESIZE;", ""));
                            }
                            if (line.startsWith("HCHERONAMESIZE;")) {
                                hm.heroNameSize = Integer.parseInt(line.replace("HCHERONAMESIZE;", ""));
                                hc.heroNameSize = Integer.parseInt(line.replace("HCHERONAMESIZE;", ""));
                            }
                            if (line.startsWith("HCRARITY;")) {
                                hc.rarity = CardRarity.valueOf(line.replace("HCRARITY;", ""));
                            }
                            if (line.startsWith("HCTEAM;")) {
                                hc.cardTeam = Icon.valueOf(line.replace("HCTEAM;", ""));
                            }
                            if (line.startsWith("HCTEAM2;")) {
                                hc.cardTeam2 = Icon.valueOf(line.replace("HCTEAM2;", ""));
                            }
                            if (line.startsWith("HCPOWER;")) {
                                hc.cardPower = Icon.valueOf(line.replace("HCPOWER;", ""));
                            }
                            if (line.startsWith("HCPOWER2;")) {
                                hc.cardPower2 = Icon.valueOf(line.replace("HCPOWER2;", ""));
                            }
                            if (line.startsWith("HCATTACK;")) {
                                hc.attack = line.replace("HCATTACK;", "");
                            }
                            if (line.startsWith("HCRECRUIT;")) {
                                hc.recruit = line.replace("HCRECRUIT;", "");
                            }
                            if (line.startsWith("HCCOST;")) {
                                hc.cost = line.replace("HCCOST;", "");
                            }
                            if (line.startsWith("HCATTACK;")) {
                                hc.attack = line.replace("HCATTACK;", "");
                            }
                            if (line.startsWith("HCTEXT;")) {
                                hc.abilityText = line.replace("HCTEXT;", "");
                            }
                            if (line.startsWith("HCTEXTOFFSET;")) {
                                hm.textStartOffset = Integer.parseInt(line.replace("HCTEXTOFFSET;", ""));
                            }
                            if (line.startsWith("HCTEXTSIZE;")) {
                                hm.textSize = Integer.parseInt(line.replace("HCTEXTSIZE;", ""));
                                hc.abilityTextSize = Integer.parseInt(line.replace("HCTEXTSIZE;", ""));
                            }
                            if (line.startsWith("HCIMAGEZOOM;")) {
                                hc.imageZoom = Double.parseDouble(line.replace("HCIMAGEZOOM;", ""));
                            }
                            if (line.startsWith("HCIMAGEPATH;")) {
                                hc.imagePath = line.replace("HCIMAGEPATH;", "");
                            }
                            if (line.startsWith("HCIMAGEOFFSETX;")) {
                                hc.imageOffsetX = Integer.parseInt(line.replace("HCIMAGEOFFSETX;", ""));
                            }
                            if (line.startsWith("HCIMAGEOFFSETY;")) {
                                hc.imageOffsetY = Integer.parseInt(line.replace("HCIMAGEOFFSETY;", ""));
                            }
                            if (line.startsWith("HCNUMBERINDECK;")) {
                                hc.numberInDeck = Integer.parseInt(line.replace("HCNUMBERINDECK;", ""));
                            }
                            if (!this.ignoreGenerate && line.startsWith("HCGENERATE;")) {
                                try {
                                    bwErr.write("Generating: " + hc.getCardName(this.exportFolder) + "\n");
                                    hm.setCard(hc);
                                    image = hm.generateCard();
                                    hm.exportImage(image);
                                    if (!this.exportBasicText) break block141;
                                    this.outputHeroCard(bw, hc);
                                    break block141;
                                }
                                catch (Exception ex) {
                                    bwErr.write(ex.getMessage());
                                    var23_29 = ex.getStackTrace();
                                    var22_27 = var23_29.length;
                                    var21_25 = 0;
                                    ** while (var21_25 < var22_27)
                                }
lbl-1000:
                                // 1 sources

                                {
                                    s = var23_29[var21_25];
                                    bwErr.write(s.toString());
                                    ++var21_25;
                                    continue;
                                }
                            }
                        }
                        if (line.startsWith("VILLAIN;")) {
                            v = new Villain();
                            if (line.replace("VILLAIN;", "").equals("system_bystander_villain")) {
                                v = this.bystanderVillain;
                            } else if (line.replace("VILLAIN;", "").equals("system_wound_villain")) {
                                v = this.woundVillain;
                            } else if (line.replace("VILLAIN;", "").equals("system_bindings_villain")) {
                                v = this.bindingsVillain;
                            } else {
                                v.name = line.replace("VILLAIN;", "");
                                this.villains.add(v);
                            }
                            if (this.exportBasicText) {
                                this.outputVillain(bw, v);
                            }
                        }
                        if (line.startsWith("VFIMAGEZOOM;")) {
                            v.imageZoom = Double.parseDouble(line.replace("VFIMAGEZOOM;", ""));
                        }
                        if (line.startsWith("VFIMAGEPATH;")) {
                            v.imagePath = line.replace("VFIMAGEPATH;", "");
                        }
                        if (line.startsWith("VFIMAGEOFFSETX;")) {
                            v.imageOffsetX = Integer.parseInt(line.replace("VFIMAGEOFFSETX;", ""));
                        }
                        if (line.startsWith("VFIMAGEOFFSETY;")) {
                            v.imageOffsetY = Integer.parseInt(line.replace("VFIMAGEOFFSETY;", ""));
                        }
                        if (line.startsWith("VILLAINCARD;")) {
                            vm = new VillainMaker();
                            vm.bwErr = bwErr;
                            vm.exportFolder = this.exportFolder;
                            vc = new VillainCard();
                            vc.villainGroup = v.name;
                            vc.villain = v;
                            v.cards.add(vc);
                        }
                        if (line.startsWith("VCNAME;")) {
                            vc.name = line.replace("VCNAME;", "");
                        }
                        if (line.startsWith("VCNAMESIZE;")) {
                            vm.cardNameSize = Integer.parseInt(line.replace("VCNAMESIZE;", ""));
                            vc.nameSize = Integer.parseInt(line.replace("VCNAMESIZE;", ""));
                        }
                        if (line.startsWith("VCTYPE;")) {
                            vc.cardType = VillainCardType.valueOf(line.replace("VCTYPE;", ""));
                            if (vc.cardType.equals((Object)VillainCardType.BYSTANDER)) {
                                this.bystanderVillain.cards.add(vc);
                                v.cards.remove(vc);
                            }
                        }
                        if (line.startsWith("VCTEAM;")) {
                            vc.cardTeam = Icon.valueOf(line.replace("VCTEAM;", ""));
                        }
                        if (line.startsWith("VCPOWER;")) {
                            vc.cardPower = Icon.valueOf(line.replace("VCPOWER;", ""));
                        }
                        if (line.startsWith("VCATTACK;")) {
                            vc.attack = line.replace("VCATTACK;", "");
                        }
                        if (line.startsWith("VCVICTORY;")) {
                            vc.victory = line.replace("VCVICTORY;", "");
                        }
                        if (line.startsWith("VCTEXT;")) {
                            vc.abilityText = line.replace("VCTEXT;", "");
                        }
                        if (line.startsWith("VCTEXTOFFSET;")) {
                            vm.textStartOffset = Integer.parseInt(line.replace("VCTEXTOFFSET;", ""));
                        }
                        if (line.startsWith("VCTEXTSIZE;")) {
                            vm.textSize = Integer.parseInt(line.replace("VCTEXTSIZE;", ""));
                            vc.abilityTextSize = Integer.parseInt(line.replace("VCTEXTSIZE;", ""));
                        }
                        if (line.startsWith("VCIMAGEZOOM;")) {
                            vc.imageZoom = Double.parseDouble(line.replace("VCIMAGEZOOM;", ""));
                        }
                        if (line.startsWith("VCIMAGEPATH;")) {
                            vc.imagePath = line.replace("VCIMAGEPATH;", "");
                        }
                        if (line.startsWith("VCIMAGEOFFSETX;")) {
                            vc.imageOffsetX = Integer.parseInt(line.replace("VCIMAGEOFFSETX;", ""));
                        }
                        if (line.startsWith("VCIMAGEOFFSETY;")) {
                            vc.imageOffsetY = Integer.parseInt(line.replace("VCIMAGEOFFSETY;", ""));
                        }
                        if (line.startsWith("VCNUMBERINDECK;")) {
                            vc.numberInDeck = Integer.parseInt(line.replace("VCNUMBERINDECK;", ""));
                        }
                        if (!this.ignoreGenerate && line.startsWith("VCGENERATE;")) {
                            try {
                                bwErr.write("Generating: " + vc.getCardName(this.exportFolder) + "\n");
                                vm.setCard(vc);
                                image = vm.generateCard();
                                vm.exportImage(image);
                                if (!this.exportBasicText) break block142;
                                this.outputVillainCard(bw, vc);
                                break block142;
                            }
                            catch (Exception ex) {
                                bwErr.write(ex.getMessage());
                                var23_29 = ex.getStackTrace();
                                var22_27 = var23_29.length;
                                var21_25 = 0;
                                ** while (var21_25 < var22_27)
                            }
lbl-1000:
                            // 1 sources

                            {
                                s = var23_29[var21_25];
                                bwErr.write(s.toString());
                                ++var21_25;
                                continue;
                            }
                        }
                    }
                    if (line.startsWith("SCHEME;")) {
                        sm = new SchemeMaker();
                        sm.bwErr = bwErr;
                        sm.exportFolder = this.exportFolder;
                        sc = new SchemeCard();
                        sc.name = line.replace("SCHEME;", "");
                        this.schemes.add(sc);
                    }
                    if (line.startsWith("SCNAMESIZE;")) {
                        sm.cardNameSize = Integer.parseInt(line.replace("SCNAMESIZE;", ""));
                        sc.cardNameSize = Integer.parseInt(line.replace("SCNAMESIZE;", ""));
                    }
                    if (line.startsWith("SCSUBNAME;")) {
                        sc.subCategory = line.replace("SCSUBNAME;", "").toUpperCase();
                    }
                    if (line.startsWith("SCSUBCATSIZE;")) {
                        sm.subCategorySize = Integer.parseInt(line.replace("SCSUBCATSIZE;", ""));
                        sc.subCategorySize = Integer.parseInt(line.replace("SCSUBCATSIZE;", ""));
                    }
                    if (line.startsWith("SCTYPE;")) {
                        sc.cardType = SchemeCardType.valueOf(line.replace("SCTYPE;", ""));
                    }
                    if (line.startsWith("SCTEXT;")) {
                        sc.cardText = line.replace("SCTEXT;", "");
                    }
                    if (line.startsWith("SCTEXTSIZE;")) {
                        sm.textSize = Integer.parseInt(line.replace("SCTEXTSIZE;", ""));
                        sc.cardTextSize = Integer.parseInt(line.replace("SCTEXTSIZE;", ""));
                    }
                    if (line.startsWith("SCIMAGEZOOM;")) {
                        sc.imageZoom = Double.parseDouble(line.replace("SCIMAGEZOOM;", ""));
                    }
                    if (line.startsWith("SCIMAGEPATH;")) {
                        sc.imagePath = line.replace("SCIMAGEPATH;", "");
                    }
                    if (line.startsWith("SCIMAGEOFFSETX;")) {
                        sc.imageOffsetX = Integer.parseInt(line.replace("SCIMAGEOFFSETX;", ""));
                    }
                    if (line.startsWith("SCIMAGEOFFSETY;")) {
                        sc.imageOffsetY = Integer.parseInt(line.replace("SCIMAGEOFFSETY;", ""));
                    }
                    if (line.startsWith("SCNUMBERINDECK;")) {
                        sc.numberInDeck = Integer.parseInt(line.replace("SCNUMBERINDECK;", ""));
                    }
                    if (!this.ignoreGenerate && line.startsWith("SCGENERATE;")) {
                        try {
                            bwErr.write("Generating: " + sc.getCardName(this.exportFolder) + "\n");
                            sm.setCard(sc);
                            image = sm.generateCard();
                            sm.exportImage(image);
                            if (!this.exportBasicText) break block143;
                            this.outputSchemeCard(bw, sc);
                            break block143;
                        }
                        catch (Exception ex) {
                            bwErr.write(ex.getMessage());
                            var23_29 = ex.getStackTrace();
                            var22_27 = var23_29.length;
                            var21_25 = 0;
                            ** while (var21_25 < var22_27)
                        }
lbl-1000:
                        // 1 sources

                        {
                            s = var23_29[var21_25];
                            bwErr.write(s.toString());
                            ++var21_25;
                            continue;
                        }
                    }
                }
                if (line.startsWith("CUSTOMCARD;")) {
                    cc = new CustomCard();
                    this.customCards.add(cc);
                }
                if (line.startsWith("TEMPLATE;")) {
                    cc.templateName = line.replace("TEMPLATE;", "");
                    for (CustomTemplate t : this.allTemplates) {
                        if (!t.templateName.equals(cc.templateName)) continue;
                        cc.template = t.getCopy();
                        break;
                    }
                }
                if (!line.startsWith("CUSTOMVALUE;")) continue;
                split = line.split(";");
                element = null;
                element = cc.template.getElement(split[1]);
                if (element == null || (field = element.getClass().getField(split[2])) == null) continue;
                value = null;
                splitVal = "";
                try {
                    value = split[3];
                    splitVal = split[3];
                }
                catch (Exception e) {
                    value = null;
                    splitVal = "";
                }
                if (field.getType().getSimpleName().equals("Icon")) {
                    value = Icon.valueOf(splitVal);
                }
                if (field.getType().getSimpleName().equals("boolean")) {
                    value = Boolean.valueOf(splitVal);
                }
                if (field.getType().getSimpleName().equals("int")) {
                    value = Integer.valueOf(splitVal);
                }
                if (field.getType().getSimpleName().equals("double")) {
                    value = Double.valueOf(splitVal);
                }
                field.set(element, value);
            }
            br.close();
            if (this.exportBasicText) {
                bw.close();
            }
            if (this.generateDividerFile) {
                this.generateDividerFile(bwDiv, this.heroes, this.villains);
                bwDiv.close();
            }
            bwErr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.currentFile = null;
        }
        this.currentFile = inputFile;
    }

    public void outputHero(BufferedWriter br, Hero h) throws Exception {
        br.newLine();
        br.write(h.name);
        br.newLine();
        br.newLine();
    }

    public void outputHeroCard(BufferedWriter br, HeroCard hc) throws Exception {
        br.write(hc.getTextExportString());
        br.newLine();
        br.newLine();
    }

    public void outputVillain(BufferedWriter br, Villain v) throws Exception {
        br.newLine();
        br.write(v.name);
        br.newLine();
        br.newLine();
    }

    public void outputVillainCard(BufferedWriter br, VillainCard vc) throws Exception {
        br.write(vc.cardType.toString());
        br.newLine();
        br.write(vc.name);
        br.newLine();
        br.write(vc.cardTeam.toString());
        br.newLine();
        if (vc.attack != null || vc.victory != null) {
            if (vc.attack != null) {
                br.write("Attack " + vc.attack);
                if (vc.victory != null) {
                    br.write(", ");
                }
            }
            if (vc.victory != null) {
                br.write("Victory Points " + vc.victory);
            }
            br.newLine();
        }
        br.write(vc.abilityText.replace("<k>", "").replace("<r>", "").replace(" <g> ", "\n"));
        br.newLine();
        br.newLine();
    }

    public void outputSchemeCard(BufferedWriter br, SchemeCard sc) throws Exception {
        br.newLine();
        br.write(sc.cardType.toString());
        br.newLine();
        br.write(sc.name);
        br.newLine();
        if (sc.subCategory != null) {
            br.write(sc.subCategory);
            br.newLine();
        }
        br.write(sc.cardText.replace("<k>", "").replace("<r>", "").replace(" <g> ", "\n").replace("</h>", "\n").replace("<h>", "\n"));
        br.newLine();
        br.newLine();
    }

    public void generateDividerFile(BufferedWriter bwDiv, List<Hero> heroes, List<Villain> villains) throws Exception {
        bwDiv.write("EXPANSION;" + this.textOutputFile);
        bwDiv.newLine();
        bwDiv.newLine();
        for (Hero h : heroes) {
            bwDiv.write("HERO;" + h.name + ";" + h.cards.get((int)(h.cards.size() - 1)).cardTeam.getEnumName());
            bwDiv.newLine();
            for (HeroCard hc : h.cards) {
                bwDiv.write("HEROCARD;" + hc.rarity.toString() + ";" + hc.cardTeam + ";" + hc.cost);
                bwDiv.newLine();
            }
            bwDiv.newLine();
        }
        for (Villain v : villains) {
            if (v.cards.get((int)(v.cards.size() - 1)).cardType.equals((Object)VillainCardType.HENCHMEN)) {
                bwDiv.write("HOMME DE MAIN;" + v.name + ";" + v.cards.get((int)(v.cards.size() - 1)).cardTeam.getEnumName());
                bwDiv.newLine();
            }
            if (v.cards.get((int)(v.cards.size() - 1)).cardType.equals((Object)VillainCardType.VILLAIN)) {
                bwDiv.write("VILLAIN;" + v.name + ";" + v.cards.get((int)(v.cards.size() - 1)).cardTeam.getEnumName());
                bwDiv.newLine();
            }
            if (v.cards.get((int)(v.cards.size() - 1)).cardType.equals((Object)VillainCardType.MASTERMIND_TACTIC) || v.cards.get((int)(v.cards.size() - 1)).cardType.equals((Object)VillainCardType.MASTERMIND)) {
                bwDiv.write("MAITRE DU MAL;" + v.name + ";" + v.cards.get((int)(v.cards.size() - 1)).cardTeam.getEnumName());
                bwDiv.newLine();
            }
            bwDiv.newLine();
        }
    }

    public void saveExpansion() throws Exception {
        this.saveExpansion(false, this.currentFile);
    }

    public void saveExpansion(boolean fullExport, String saveFile) throws Exception {
        String str = "";
        str = String.valueOf(str) + "EXPANSIONSTYLE;" + expansionStyle;
        str = String.valueOf(str) + "\n\n";
        str = String.valueOf(str) + "EXPANSIONNAME;" + this.expansionName;
        str = String.valueOf(str) + "\n\n";
        str = String.valueOf(str) + "RULES;" + this.rules;
        str = String.valueOf(str) + "\n\n";
        str = String.valueOf(str) + "KEYWORDS;" + this.keywords;
        str = String.valueOf(str) + "\n\n";
        str = String.valueOf(str) + "DIVIDERORIENTATION;" + (this.dividerHorizontal ? "HORIZONTAL" : "VERTICAL");
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + "DIVIDERCARDSTYLE;" + this.dividerCardStyle + "\n";
        str = String.valueOf(str) + "DIVIDERBODYSTYLE;" + this.dividerBodyStyle + "\n";
        str = String.valueOf(str) + "DTITLEBARCOLOUR;" + (this.dividerTitleBarColour == null ? Color.white.getRGB() : this.dividerTitleBarColour.getRGB()) + "\n";
        str = String.valueOf(str) + "DTITLEBARVISIBLE;" + this.dividerTitleBarVisible + "\n";
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + HeroMaker.generateTemplateOutputString();
        if (this.dfImagePath != null) {
            str = String.valueOf(str) + "DFIMAGEPATH;" + this.dfImagePath + "\n";
        }
        if (this.dfImagePath != null) {
            str = String.valueOf(str) + "DFIMAGEZOOM;" + this.dfImageZoom + "\n";
        }
        if (this.dfImagePath != null) {
            str = String.valueOf(str) + "DFIMAGEOFFSETX;" + this.dfImageOffsetX + "\n";
        }
        if (this.dfImagePath != null) {
            str = String.valueOf(str) + "DFIMAGEOFFSETY;" + this.dfImageOffsetY + "\n";
        }
        if (this.dbImagePath != null) {
            str = String.valueOf(str) + "DBIMAGEPATH;" + this.dbImagePath + "\n";
        }
        if (this.dbImagePath != null) {
            str = String.valueOf(str) + "DBIMAGEZOOM;" + this.dbImageZoom + "\n";
        }
        if (this.dbImagePath != null) {
            str = String.valueOf(str) + "DBIMAGEOFFSETX;" + this.dbImageOffsetX + "\n";
        }
        if (this.dbImagePath != null) {
            str = String.valueOf(str) + "DBIMAGEOFFSETY;" + this.dbImageOffsetY + "\n";
        }
        str = String.valueOf(str) + "\n\n";
        for (Hero hero : this.heroes) {
            str = String.valueOf(str) + hero.generateOutputString();
            str = String.valueOf(str) + "\n\n";
        }
        for (Villain villain : this.villains) {
            str = String.valueOf(str) + villain.generateOutputString();
            str = String.valueOf(str) + "\n\n";
        }
        for (SchemeCard schemeCard : this.schemes) {
            str = String.valueOf(str) + schemeCard.generateOutputString();
            str = String.valueOf(str) + "\n\n";
        }
        for (CustomCard customCard : this.customCards) {
            str = String.valueOf(str) + customCard.generateOutputString();
            str = String.valueOf(str) + "\n\n";
        }
        FileWriter fileWriter = new FileWriter(new File(saveFile));
        BufferedWriter bw = new BufferedWriter(fileWriter);
        bw.write(str);
        bw.close();
        fileWriter.close();
        this.markAsChanged(false);
    }

    public void markAsChanged(boolean flag) throws Exception {
        for (Hero hero : this.heroes) {
            hero.changed = flag;
            for (HeroCard hc : hero.cards) {
                hc.changed = flag;
            }
        }
        for (Villain villain : this.villains) {
            villain.changed = flag;
            for (VillainCard vc : villain.cards) {
                vc.changed = flag;
            }
        }
        for (SchemeCard schemeCard : this.schemes) {
            schemeCard.changed = flag;
        }
        for (CustomCard customCard : this.customCards) {
            customCard.changed = flag;
        }
    }

    public boolean doChangesExist() {
        for (Hero h : this.heroes) {
            if (h.changed) {
                return true;
            }
            for (HeroCard heroCard : h.cards) {
                if (!heroCard.changed) continue;
                return true;
            }
        }
        for (Villain v : this.villains) {
            if (v.changed) {
                return true;
            }
            for (VillainCard villainCard : v.cards) {
                if (!villainCard.changed) continue;
                return true;
            }
        }
        for (SchemeCard s : this.schemes) {
            if (!s.changed) continue;
            return true;
        }
        for (CustomCard cc : this.customCards) {
            if (!cc.changed) continue;
            return true;
        }
        return false;
    }

    public void exportToPng(File folder) throws Exception {
        for (Hero h : this.heroes) {
            this.exportHeroToPng(h, folder);
        }
        for (Villain v : this.villains) {
            this.exportVillainToPng(v, folder);
        }
        for (SchemeCard s : this.schemes) {
            this.exportSchemeToPng(s, folder);
        }
    }

    public int getCardCount() throws Exception {
        int count = 0;
        for (Hero h : this.heroes) {
            ++count;
        }
        for (Villain v : this.villains) {
            ++count;
        }
        for (SchemeCard s : this.schemes) {
            ++count;
        }
        for (CustomCard cc : this.customCards) {
            ++count;
        }
        return count;
    }

    public void exportHeroToPng(Hero h, File folder) throws Exception {
        for (HeroCard hc : h.cards) {
            HeroMaker hm = new HeroMaker();
            hm.exportFolder = folder.getAbsolutePath();
            hm.setCard(hc);
            BufferedImage image = hm.generateCard();
            hm.exportImage(image);
        }
    }

    public void exportVillainToPng(Villain v, File folder) throws Exception {
        for (VillainCard vc : v.cards) {
            VillainMaker vm = new VillainMaker();
            vm.exportFolder = folder.getAbsolutePath();
            vm.setCard(vc);
            BufferedImage image = vm.generateCard();
            vm.exportImage(image);
        }
    }

    public void exportSchemeToPng(SchemeCard s, File folder) throws Exception {
        SchemeMaker sm = new SchemeMaker();
        sm.exportFolder = folder.getAbsolutePath();
        sm.setCard(s);
        BufferedImage image = sm.generateCard();
        sm.exportImage(image);
    }

    public void exportHeroToJpeg(Hero h, File folder) throws Exception {
        for (HeroCard hc : h.cards) {
            HeroMaker hm = new HeroMaker();
            hm.exportToPNG = false;
            hm.exportFolder = folder.getAbsolutePath();
            hm.setCard(hc);
            BufferedImage image = hm.generateCard();
            hm.exportImage(image);
        }
    }

    public void exportVillainToJpeg(Villain v, File folder) throws Exception {
        for (VillainCard vc : v.cards) {
            VillainMaker vm = new VillainMaker();
            vm.exportToPNG = false;
            vm.exportFolder = folder.getAbsolutePath();
            vm.setCard(vc);
            BufferedImage image = vm.generateCard();
            vm.exportImage(image);
        }
    }

    public void exportSchemeToJpeg(SchemeCard s, File folder) throws Exception {
        SchemeMaker sm = new SchemeMaker();
        sm.exportToPNG = false;
        sm.exportFolder = folder.getAbsolutePath();
        sm.setCard(s);
        BufferedImage image = sm.generateCard();
        sm.exportImage(image);
    }

    public void exportCustomCardToJpeg(CustomCard s, File folder) throws Exception {
        CustomCardMaker sm = new CustomCardMaker();
        sm.exportToPNG = false;
        sm.exportFolder = folder.getAbsolutePath();
        sm.setCard(s);
        BufferedImage image = sm.generateCard();
        sm.exportImage(image);
    }

    public void exportCustomCardToPng(CustomCard s, File folder) throws Exception {
        CustomCardMaker sm = new CustomCardMaker();
        sm.exportFolder = folder.getAbsolutePath();
        sm.setCard(s);
        BufferedImage image = sm.generateCard();
        sm.exportImage(image);
    }

    public static void debug(String message) {
        if (debug) {
            System.out.println(message);
        }
    }

    public void loadTemplates() {
        System.out.println("Loading Custom Templates");
        this.allTemplates = new ArrayList<CustomTemplate>();
        String templateFolder = "legendary" + File.separator + "templates" + File.separator + "custom";
        File dir = new File(templateFolder);
        if (dir.exists()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File templateFile;
                File f = fileArray[n2];
                if (f.isDirectory() && (templateFile = this.getTemplateFile(f)) != null) {
                    CustomTemplate template = CustomTemplate.parseCustomTemplate(templateFolder, f.getName());
                    this.allTemplates.add(template);
                    System.out.println("Loaded: " + template.templateName);
                }
                ++n2;
            }
        }
    }

    public void loadStructures() {
        System.out.println("Loading Custom Templates");
        this.allStructures = new ArrayList<CustomStructure>();
        String templateFolder = "legendary" + File.separator + "structures";
        File dir = new File(templateFolder);
        if (dir.exists()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().endsWith(".xml")) {
                    CustomStructure template = CustomStructure.parseCustomStructure(f);
                    this.allStructures.add(template);
                    System.out.println("Loaded: " + template.name);
                }
                ++n2;
            }
        }
    }

    private File getTemplateFile(File f) {
        File[] fileArray = f.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().toLowerCase().equals("template.xml")) {
                return file;
            }
            ++n2;
        }
        return null;
    }
}

